% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{check_data_item_version}
\alias{check_data_item_version}
\title{Check the data item to ensure that it is valid for the version specified}
\usage{
check_data_item_version(data_item, version = 1, silent = TRUE)
}
\arguments{
\item{data_item}{character; the data item to check}

\item{version}{character/numeric; the API version, either as a number (e.g. \code{1}) or as a case-insensitive string (e.g. "v1" or "V2"). Default is 1.}

\item{silent}{boolean; whether to show a warning if that version is not valid for the provided
data item. Default is TRUE.}
}
\value{
boolean; returns \code{TRUE} if data_item is valid for the provided version, \code{FALSE} if it is not
}
\description{
Currently, "B1610" is the only data item that no longer supports v1 and equally is the only data item that supports v2.
}
\examples{
check_data_item_version("B1610", 1)
check_data_item_version("B1710", 1)
}
