% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Spike_Laplace.R
\name{spike_laplace_partially_mcmc}
\alias{spike_laplace_partially_mcmc}
\title{Spike-and-Laplace MCMC Sampler for Multiply-Imputed Regression}
\usage{
spike_laplace_partially_mcmc(
  X,
  Y,
  intercept = TRUE,
  a = 2,
  b = NULL,
  nburn = 4000,
  npost = 4000,
  seed = NULL,
  verbose = TRUE,
  printevery = 1000,
  chain_index = 1
)
}
\arguments{
\item{X}{A 3-D array of predictors with dimensions \code{D * n * p}.}

\item{Y}{A matrix of outcomes with dimensions \code{D * n}.}

\item{intercept}{Logical; include an intercept term? Default \code{TRUE}.}

\item{a}{Numeric; shape parameter of the Gamma prior. Default \code{2}.}

\item{b}{Numeric or \code{NULL}; scale parameter of the Gamma prior. If \code{NULL},
defaults to \code{0.5*(D+1)/(D*(a-1))}.}

\item{nburn}{Integer; number of burn-in MCMC iterations. Default \code{4000}.}

\item{npost}{Integer; number of post-burn-in samples to retain. Default \code{4000}.}

\item{seed}{Integer or \code{NULL}; random seed for reproducibility. Default \code{NULL}.}

\item{verbose}{Logical; print progress messages? Default \code{TRUE}.}

\item{printevery}{Integer; print progress every this many iterations. Default \code{1000}.}

\item{chain_index}{Integer; index of this MCMC chain (for labeling messages). Default \code{1}.}
}
\value{
A named list with components:
\describe{
\item{\code{post_rho}}{Numeric vector length \code{npost}, sampled global scale \eqn{\rho}.}
\item{\code{post_gamma}}{Matrix \code{npost * p} of sampled inclusion indicators.}
\item{\code{post_theta}}{Matrix \code{npost * p} of sampled Beta parameters \eqn{\theta_j}.}
\item{\code{post_alpha}}{Matrix \code{npost * D} of sampled intercepts (if used).}
\item{\code{post_lambda2}}{Matrix \code{npost * p} of sampled local scale parameters \eqn{\lambda_j^2}.}
\item{\code{post_sigma2}}{Numeric vector length \code{npost}, sampled residual variances.}
\item{\code{post_beta}}{Array \code{npost * D * p} of sampled regression coefficients.}
\item{\code{post_fitted_Y}}{Array \code{npost * D * n} of posterior predictive draws (including noise).}
\item{\code{post_pool_beta}}{Matrix \code{(npost * D) * p} of pooled coefficient draws.}
\item{\code{post_pool_fitted_Y}}{Matrix \code{(npost * D) * n} of pooled predictive draws (with noise).}
\item{\code{hat_matrix_proj}}{Matrix \code{D * n * n} of averaged projection hat-matrices. To avoid recalculate for estimating degree of freedom.}
\item{\code{a}, \code{b}}{Numeric values of the rho hyperparameters used.}
}
}
\description{
Implements Bayesian variable selection using a spike-and-slab prior with a Laplace (double-exponential) slab
on nonzero coefficients. Latent inclusion indicators \code{gamma} follow Bernoulli(\code{theta}), and their probabilities
follow independent Beta(\code{a}, \code{b}) priors.
}
\examples{
sim <- sim_B(n = 100, p = 20, type = "MAR", SNP = 1.5, corr = 0.5,
low_missing = TRUE, n_imp = 5, seed = 123)
X <- sim$data_MI$X
Y <- sim$data_MI$Y
fit <- spike_laplace_partially_mcmc(X, Y, nburn = 10, npost = 10)
}
