\name{wheat}
\alias{wheat}
\title{wheat dataset}
\description{

Information from a collection of 599 historical CIMMYT wheat lines.  The wheat data set is from 
CIMMYT's Global Wheat Program. Historically, this program has conducted numerous international 
trials across a wide variety of wheat-producing environments. The environments represented in 
these trials were grouped into four basic target sets of environments comprising four 
main agroclimatic regions previously defined and widely used by CIMMYT's Global Wheat Breeding Program. 
The phenotypic trait considered here was the average grain yield (GY) of the 599 wheat lines evaluated 
in each of these four mega-environments. 

A pedigree tracing back many generations was available, and the Browse application of 
the International Crop Information System (ICIS), as described in 
\url{http://cropwiki.irri.org/icis/index.php/TDM_GMS_Browse} (McLaren \emph{et al.} 2005), was used 
for deriving the relationship matrix A among the 599 lines; it accounts for selection and inbreeding.

Wheat lines were recently genotyped using 1447 Diversity Array Technology (DArT) generated by 
Triticarte Pty. Ltd. (Canberra, Australia; \url{http://www.triticarte.com.au}). The DArT markers 
may take on two values, denoted by their presence or absence. Markers with a minor allele frequency 
lower than 0.05 were removed, and missing genotypes were imputed with samples from the marginal 
distribution of marker genotypes, that is, \eqn{x_{ij}=Bernoulli(\hat p_j)}, where  \eqn{\hat p_j}  
is the estimated allele frequency computed from the non-missing genotypes. The number of DArT 
MMs after edition was 1279.

}

\usage{
  data(wheat)
}

\format{
 Matrix Y contains the average grain yield, column 1: Grain yield for environment 1 and so on. The matrix A contains additive relationship
 computed from the pedigree and matrix X contains the markers information. 
}

\source{
  International Maize and Wheat Improvement Center (CIMMYT), Mexico.
}

\references{
McLaren, C. G., R. Bruskiewich, A.M. Portugal, and A.B. Cosico. 2005. The International Rice Information System. 
A platform for meta-analysis of rice crop data. \emph{Plant Physiology} \bold{139}: 637-642.
}
\keyword{datasets}
