\name{BINCO.plot}
\alias{BINCO.plot}
\title{Illustrate the fitting performance of \code{BINCO}}
\description{A function to produce an overlay plot of the empirical mixture 
            distribution of selection frequencies and the null distribution 
            estimated by \code{BINCO}}

\usage{
BINCO.plot(out.BINCO,show.range=NULL,show.cutoff=TRUE,...)
      }

\arguments{
    \item{out.BINCO}{a list as the result returned by \code{BINCO}
                    function.}
                    
    \item{show.range}{a vector of length 2, which defines the display range of 
                        the overlay plot. The lower bound of this range is set by
                        default to be the same as that of the fitting range used 
                        by \code{BINCO} and we recommend it to be no less. The 
                        default upper bound of the display range is 1.} 
                      
    \item{show.cutoff}{a logic value. Default is true and a vertical lines will 
                        be drawn at the cutoff value calculated by \code{BINCO} 
                        function.}
    \item{...}{Other additional arguments for the plot.} 
    }
                        
\details{
    \code{BINCO.plot} checks the fitting performance of \code{BINCO} function by 
    displaying the empirical mixture and the fitted null distribution in the same
    plot.}
        
        
\value{NA.}
      
\references{S. Li, L. Hsu, J. Peng and P. Wang (2012) Bootstrap Inference for 
            Network Construction. \code{http://arxiv.org/abs/1111.5028}}
            
\author{S. Li, L. Hsu, J. Peng and P. Wang}

\keyword{methods}

\examples{
################################################################################
###### BINCO applies on selection frequency data (generated using space ########
################################################################################

# load the selection frequency data, an empirical edge count distribution (Y) 
# generated by space (see Peng et al., 2009 for details)
data(BINCOSimulation)
# apply BINCO on Y
out=BINCO(count.mix=BINCOSimulation$Y)
# make the plot
BINCO.plot(out.BINCO=out)
# Zoom in at the tail
BINCO.plot(out.BINCO=out, show.range=c(0.4,0.99))
}

