% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.R
\name{simulateNull}
\alias{simulateNull}
\title{Simulate data from a given null model and monotherapy coefficients}
\usage{
simulateNull(
  data,
  fitResult,
  transforms = fitResult$transforms,
  null_model = c("loewe", "hsa", "bliss", "loewe2"),
  ...
)
}
\arguments{
\item{data}{Dose-response dataframe.}

\item{fitResult}{Monotherapy (on-axis) model fit, e.g. produced by
\code{\link{fitMarginals}}. It has to be a \code{"MarginalFit"} object or a
list containing \code{df}, \code{sigma}, \code{coef},
\code{shared_asymptote} and \code{method} elements for, respectively,
marginal model degrees of freedom, residual standard deviation, named
vector of coefficient estimates, logical value of whether shared asymptote
is imposed and method for estimating marginal models during bootstrapping
(see \code{\link{fitMarginals}}). If biological and power transformations
were used in marginal model estimation, \code{fitResult} should contain
\code{transforms} elements with these transformations. Alternatively, these
can also be specified via \code{transforms} argument.}

\item{transforms}{Transformation functions. If non-null, \code{transforms} is
a list containing 5 elements, namely biological and power transformations
along with their inverse functions and \code{compositeArgs} which is a list
with argument values shared across the 4 functions. See vignette for more
information.}

\item{null_model}{Specified null model for the expected response surface.
Currently, allowed options are \code{"loewe"} for generalized Loewe model,
\code{"hsa"} for Highest Single Agent model, \code{"bliss"} for Bliss additivity,
and \code{"loewe2"} for the alternative Loewe generalization.}

\item{...}{Further parameters that will be passed to
\code{\link{generateData}}}
}
\value{
List with \code{data} element containing simulated data and
  \code{fitResult} element containing marginal fit on the simulated data.
}
\description{
Simulate data from a given null model and monotherapy coefficients
}
\examples{
  data <- subset(directAntivirals, experiment == 1)
  ## Data must contain d1, d2 and effect columns
  fitResult <- fitMarginals(data)
  simulateNull(data, fitResult, null_model = "hsa")
}
