% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tweakPedigree.R
\name{makeInbreeding}
\alias{makeInbreeding}
\title{makeInbreeding
A function to create inbred mates in the simulated pedigree \code{data.frame}.
Inbred mates can be created by specifying their IDs or the generation the inbred mate should be created.
When specifying the generation, inbreeding between siblings or 1st cousin needs to be specified.
This is a supplementary function for \code{simulatePedigree}.}
\usage{
makeInbreeding(
  ped,
  ID_mate1 = NA_integer_,
  ID_mate2 = NA_integer_,
  verbose = FALSE,
  gen_inbred = 2,
  type_inbred = "sib"
)
}
\arguments{
\item{ped}{A \code{data.frame} in the same format as the output of \code{simulatePedigree}.}

\item{ID_mate1}{A vector of \code{ID} of the first mate. If not provided, the function will randomly select two individuals from the second generation.}

\item{ID_mate2}{A vector of \code{ID} of the second mate.}

\item{verbose}{logical.  If TRUE, print progress through stages of algorithm}

\item{gen_inbred}{A vector of \code{generation} of the twin to be imputed.}

\item{type_inbred}{A character vector indicating the type of inbreeding. "sib" for sibling inbreeding and "cousin" for cousin inbreeding.}
}
\value{
Returns a \code{data.frame} with some inbred mates.
}
\description{
makeInbreeding
A function to create inbred mates in the simulated pedigree \code{data.frame}.
Inbred mates can be created by specifying their IDs or the generation the inbred mate should be created.
When specifying the generation, inbreeding between siblings or 1st cousin needs to be specified.
This is a supplementary function for \code{simulatePedigree}.
}
\details{
This function creates inbred mates in the simulated pedigree \code{data.frame}. This function's purpose is to evaluate the effect of inbreeding on model fitting and parameter estimation. In case it needs to be said, we do not condone inbreeding in real life. But we recognize that it is a common practice in some fields to create inbred strains for research purposes.
}
