% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/documentData.R
\docType{data}
\name{inbreeding}
\alias{inbreeding}
\title{Artificial pedigree data on eight families with inbreeding}
\format{
A data frame (and ped object) with 134 rows and 7 variables
}
\usage{
data(inbreeding)
}
\description{
A dataset created purely from imagination that includes several types of inbreeding.
Different kinds of inbreeding occur in each extended family.
}
\details{
The types of inbreeding are as follows:

\itemize{
    \item Extended Family 1: Sister wives - Children with the same father and different mothers who are sisters.
    \item Extended Family 2: Full siblings have children.
    \item Extended Family 3: Half siblings have children.
    \item Extended Family 4: First cousins have children.
    \item Extended Family 5: Father has child with his daughter.
    \item Extended Family 6: Half sister wives - Children with the same father and different mothers who are half sisters.
    \item Extended Family 7: Uncle-niece and Aunt-nephew have children.
    \item Extended Family 8: A father-son pairs has children with a corresponding mother-daughter pair.
}

Although not all of the above structures are technically inbreeding, they aim to test pedigree diagramming and path tracing algorithms.

The variables are as follows:

\itemize{
  \item \code{ID}:  Person identification variable
  \item \code{sex}:  Sex of the ID: 1 is female; 0 is male
  \item \code{dadID}:  ID of the father
  \item \code{momID}:  ID of the mother
  \item \code{FamID}:  ID of the extended family
  \item \code{Gen}:  Generation of the person
  \item \code{proband}:  Always FALSE
}
}
\keyword{datasets}
