% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formula.R
\name{inferRelatedness}
\alias{inferRelatedness}
\title{Infer Relatedness Coefficient}
\usage{
inferRelatedness(cor_obs, ace_A = 0.9, ace_C = 0, shared_C = 0)
}
\arguments{
\item{cor_obs}{Numeric. Observed correlation between the two groups. Must be between -1 and 1.}

\item{ace_A}{Numeric. Proportion of variance attributable to additive genetic variance. Must be between 0 and 1. Default is 0.9.}

\item{ace_C}{Numeric. Proportion of variance attributable to shared environmental variance. Must be between 0 and 1. Default is 0.}

\item{shared_C}{Numeric. Proportion of shared environment shared between the two individuals. Must be between 0 and 1. Default is 0.}
}
\value{
Calculated relatedness coefficient (`est_r`).
}
\description{
The function uses the ACE framework to infer the relatedness between two individuals.
}
\details{
Infers the relatedness coefficient between two groups based on the observed correlation between their additive genetic variance and shared environmental variance.
}
\examples{
\dontrun{
# Infer the relatedness coefficient:
inferRelatedness(cor_obs = 0.5, ace_A = 0.9, ace_C = 0, shared_C = 0)
}
}
