% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bgvar.R
\name{vcov}
\alias{vcov}
\alias{vcov.bgvar}
\title{Extract variance-covariance matrix}
\usage{
\method{vcov}{bgvar}(object, ..., quantile = 0.5)
}
\arguments{
\item{object}{an object of class \code{bgvar}.}

\item{...}{additional arguments.}

\item{quantile}{reported quantiles. Default is set to median.}
}
\value{
Returns an \code{q} times \code{K} times \code{K} array of the global variance-covariance matrix, where \code{q} is the number of specified quantiles (this dimension is dropped if \code{q=1}) and  \code{K} the number of endogenous variables.
}
\description{
Extracts the global variance-covariance matrix for \code{bgvar} for certain quantiles of the posterior distribution.
}
\examples{
\donttest{
library(BGVAR)
data(eerData)
model.ng <- bgvar(Data=eerData,W=W.trade0012,plag=1,draws=100,burnin=100)
vcov(model.ng)
}
}
