% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bgvar_main.R
\name{plot.bgvar.resid}
\alias{plot.bgvar.resid}
\title{Plotting function for residuals}
\usage{
\method{plot}{bgvar.resid}(x, ..., global = TRUE, resp = NULL)
}
\arguments{
\item{x}{an object of class \code{bgvar.res}.}

\item{...}{additional arguments.}

\item{global}{if \code{TRUE} global residuals are plotted, otherwise country residuals.}

\item{resp}{default to \code{NULL}. Either specify a single country or a group of variables to be plotted.}
}
\value{
No return value.
}
\description{
Either plots country-residuals or the global-residuals.
}
\examples{
\donttest{
library(BGVAR)
data(eerData)
model.ssvs <- bgvar(Data=eerData,W=W.trade0012,plag=1,saves=100,burns=100,
                    prior="SSVS")
summary(model.ssvs)
res <- residuals(model.ssvs)
plot(res, resp="EA")
}
}
