% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/virf.R
\name{virf}
\alias{virf}
\title{Estimating multivariate volatility impulse response functions (VIRF) for BEKK models}
\usage{
virf(
  x,
  time = 1,
  q = 0.05,
  index_series = 1,
  n.ahead = 10,
  ci = 0.9,
  time_shock = FALSE
)
}
\arguments{
\item{x}{An object of class "bekkfit" from function \link{bekk_fit}.}

\item{time}{Time instance to calculate VIRFs for.}

\item{q}{A number specifying the quantile to be considered for a shock on which basis the VIRFs are generated.}

\item{index_series}{An integer defining the number of series for which a shock is assumed.}

\item{n.ahead}{An integer defining the number periods for which the VIRFs are generated.}

\item{ci}{A number defining the confidence level for the confidence bands.}

\item{time_shock}{Boolean indicating if the estimated residuals at date specified by "time" shall be used as a shock.}
}
\value{
Returns an object of class "virf".
}
\description{
Method for estimating VIRFs of N-dimensional BEKK models. Currently, only VIRFs for symmetric BEKK models are implemented.
}
\examples{
\donttest{

data(StocksBonds)
obj_spec <- bekk_spec()
x1 <- bekk_fit(obj_spec, StocksBonds, QML_t_ratios = FALSE, max_iter = 50, crit = 1e-9)

# 250 day ahead VIRFs and 90\% CI for a Shock in the 1\% quantile  of Bonds (i.e. series=2)
# shock is supposed to occur at day 500
x2 <- virf(x1, time = 500, q = 0.01, index_series=2, n.ahead = 500, ci = 0.90)
plot(x2)
}
}
\references{
Hafner CM, Herwartz H (2006). Volatility impulse responses for multivariate GARCH models:  An exchange rate illustration. Journal of International Money and Finance,25,719–740.
}
