% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/targeting_motive_plot.R
\name{targeting_motive_plot}
\alias{targeting_motive_plot}
\title{Polt of the difference at three positions before and after a mutation to identify the hotspot motifs.}
\usage{
targeting_motive_plot(pwm, xaxis = TRUE, yaxis = TRUE, xfontsize = 15,
  yfontsize = 15, xlim)
}
\arguments{
\item{pwm}{Result of the function hotspot().}

\item{xaxis}{Accept TRUE/FALSE parameter. TRUE draw X-axis.}

\item{yaxis}{Accept TRUE/FALSE parameter. TRUE draw Y-axis.}

\item{xfontsize}{The plot size of the X-axis.}

\item{yfontsize}{The plot size of the Y-axis.}

\item{xlim}{Limit of the drowed Y-axis.}
}
\value{
Output is plot the sequence logos around the mutation.
}
\description{
The the difference (%) at three positions before and after a mutation can be plotted using the function targeting_motive_plot().
}
\note{
The Function are based on functions from package segLogo.
}
\examples{
data(IMGTtab2)
data(IMGTtab7)
germline<-germlineReconstr(IMGTtab2$V_REGION, IMGTtab7$V_REGION)
data<-targetingMatrix(data_tab2=IMGTtab2, data_tab_germline=germline, data_tab7=IMGTtab7)
targeting_motiv_data<-targeting_motiv(data)
targeting_motive_plot(targeting_motiv_data$A, xfontsize = 15, yfontsize = 15, xlim=60 )

}
\references{
Spencer J. and Dunn-Walters DK.  Hypermutation at A-T base pairs: the A nucleotidereplacement spectrum is affected by adjacent nucleotides and there is no reverse comple-mentary of sequences flanking muated A and T nucleotides.J Immunol, 175(8):5170 - 5177,2005.

Zuckerman NS., Hazanov H., Barak M., Edelman H., Hess S., Shcolnik H., Dunn-Walters D.,and Mehr R. Somatic hypermutation and antigen-driven selection of B cells are altered inautoimmune diseases.J Autoimmun, 35(4):325 - 335, 2010. doi: 10.1016/j.jaut.2010.07.004.

Bembom O. seqLogo: Sequence logos for DNA sequence alignments, Status 10.08.2016. URLhttp://www.bioconductor.org/packages/release/bioc/html/seqLogo.html.

Schneider TD. and Stephens RM. Sequence logos: a new way to display consensus sequences.Nucleic Acids Res, 18(20):6097 - 6100, 1990.
}
