% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.pairwise.R
\name{summary.pairwise}
\alias{summary.pairwise}
\title{Summary Method for Objects of Class \code{pairwise}}
\usage{
\method{summary}{pairwise}(object, wtp = 25000, ...)
}
\arguments{
\item{object}{A \code{pairwise} object containing the results of the Bayesian
modelling and the economic evaluation.}

\item{wtp}{The value of the willingness to pay threshold used in the
summary table.}

\item{...}{Additional arguments affecting the summary produced.}
}
\value{
Prints a summary table with some information on the health economic
output and synthetic information on the economic measures (EIB, CEAC, EVPI).
}
\description{
Produces a table printout with some summary results of the health economic
evaluation.
}
\examples{
data(Vaccine)
he <- bcea(eff, cost, interventions = treats, ref = 2)
he_multi <- multi.ce(he)
summary(he_multi)

}
\references{
\insertRef{Baio2011}{BCEA}

\insertRef{Baio2013}{BCEA}
}
\seealso{
\code{\link{bcea}} \code{\link{multi.ce}}
}
\author{
Gianluca Baio
}
\keyword{print}
