% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rissanen.R
\name{rissanen}
\alias{rissanen}
\title{Rissanen's universal prior for integers}
\usage{
rissanen(n)
}
\arguments{
\item{n}{a vector of positive integers}
}
\value{
The mass assigned to each positive integer in the input vector of integers \code{n}  by Rissanen's universal prior for positive integers
\deqn{Q(n)=2^{-\log^*(n)} \qquad n>0}
where
\eqn{\log^*(x)= \log(x)+\log( \log (x))  + \log( \log (\log (x)))....}
where the sum involves only the non-negative terms.
Notice that masses are not normalized hence they do not add to one,
but to a finite positive real constant
\deqn{c = \sum_{n=1}^\infty Q(n)}
}
\description{
It returns (up to normalizing constant) the mass assigned to each positive integer or a vector of integers by Rissanen's universal prior for positive integers
}
\details{
Rissanen's universal prior on positive integers is one of the default options for eliciting a noninformative prior distribution on the unknown population size \eqn{N}. It is a proper prior with tails of the order between \eqn{1/N} and \eqn{1/N^2}
}
\examples{
# Notice that masses are not normalized hence they do not add to one,
# but to a finite positive real constant c

rissanen(1:5)

}
\references{
Rissanen, J. (1983) A universal prior for integers and estimation by minimum description length. Ann. Statist. 11, no. 2, 416-431
}
\author{
Danilo Alunni Fegatelli and Luca Tardella
}
