% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_pop_pyramid.R
\name{get_pop_pyramid}
\alias{get_pop_pyramid}
\title{Population pyramid}
\usage{
get_pop_pyramid(df, title, language)
}
\arguments{
\item{df}{Data frame that contains the ACB players' nationality.}

\item{title}{Title of the plot}

\item{language}{String, "eng" for English labels; "esp" for Spanish labels.}
}
\value{
Graphical device.
}
\description{
This is the code to get a population pyramid with the number of both Spanish 
and foreigner players along the seasons for the ACB league. 
This aids in discussion of nationality imbalance.
}
\examples{
\dontrun{
 # Load the data_app_acb file with the ACB games 
 # from seasons 1985-1986 to 2017-2018:
 load(url("http://www.uv.es/vivigui/softw/data_app_acb.RData"))
 title <- " Number of Spanish and foreign players along the ACB seasons \n Data from www.acb.com"
 get_pop_pyramid(data_app_acb, title, "eng")
}

}
\author{
Guillermo Vinue
}
