% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_similar_teams.R
\name{get_similar_teams}
\alias{get_similar_teams}
\title{Similar teams to archetypoids}
\usage{
get_similar_teams(atype, threshold, alphas, cases, data, variables)
}
\arguments{
\item{atype}{Number assigned to the archetypoid (1:length(\code{cases})) from which
searching the players who most resemble to it.}

\item{threshold}{Similarity threshold.}

\item{alphas}{Alpha values of all the players.}

\item{cases}{Archetypoids.}

\item{data}{Data frame with the statistics.}

\item{variables}{Statistics used to compute the archetypoids.}
}
\value{
Data frame with the features of the similar teams.
}
\description{
Similar teams to the archetypoids computed with 
\code{\link[Anthropometry]{archetypoids}} according to a similarity threshold.
}
\examples{
\dontrun{
(s0 <- Sys.time())
library(Anthropometry)
df <- do_join_games_bio("ACB", acb_games_1718, acb_players_1718)
df$Compet <- "ACB"
df_teams <- do_stats_teams(df, "2017-2018", "ACB", "Regular Season")
df_team_total <- df_teams$df_team_total

df3 <- df_team_total[, c("PTS", "PTSrv", "Team")]
preproc <- preprocessing(df3[,1:2], stand = TRUE, percAccomm = 1)
set.seed(4321)
lass <- stepArchetypesRawData(preproc$data, 1:2, numRep = 20, verbose = FALSE)
res <- archetypoids(2, preproc$data, huge = 200, step = FALSE, ArchObj = lass,
                    nearest = "cand_ns", sequ = TRUE)
cases <- anthrCases(res)
df3[cases,]
alphas <- round(res$alphas, 4)

get_similar_teams(1, 0.95, alphas, cases, df_team_total, c("PTS", "PTSrv"))
s1 <- Sys.time() - s0
s1
}                     

}
\seealso{
\code{\link[Anthropometry]{archetypoids}}
}
\author{
Guillermo Vinue
}
