% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_volume_threes.R
\name{do_volume_threes}
\alias{do_volume_threes}
\title{Volume of three-point shots}
\usage{
do_volume_threes(df)
}
\arguments{
\item{df}{Data frame with the games and the players info.}
}
\value{
A data frame with the volume statistics.
}
\description{
This function computes the three-point shots volume, both in offense in defense.
This volume is defined as the percentage of three-point shots attempted with respect 
to the total field-goal attempts.
}
\examples{
library(dplyr)

df0 <- do_join_games_bio("ACB", acb_games_1718, acb_players_1718) 

df1 <- df0 \%>\% rename(game_code = Game)

data_volume <- do_volume_threes(df1)

data_volume$data_volume_threes
data_volume$data_volume_threes_comp
                 
}
\author{
Guillermo Vinue
}
