% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betapriors.R
\name{testBF.prior}
\alias{testBF.prior}
\title{Test based Bayes Factors for BMA Models}
\usage{
testBF.prior(g)
}
\arguments{
\item{g}{a scalar used in the covariance of Zellner's g-prior, Cov(beta) =
sigma^2 g (X'X)^-}
}
\value{
returns an object of class "prior", with the family and
hyerparameters.
}
\description{
Creates an object representing the prior distribution on coefficients for
BAS that corresponds to the test-based Bayes Factors.
}
\details{
Creates a prior object structure used for BAS in `bas.glm`.
}
\examples{

testBF.prior(100)
library(MASS)
data(Pima.tr)

# use g = n
bas.glm(type ~ ., data=Pima.tr, family=binomial(),
        betaprior=testBF.prior(nrow(Pima.tr)),
        modelprior=uniform(), method="BAS")
}
\seealso{
\code{\link{g.prior}}, \code{\link{bas.glm}}

Other beta priors: \code{\link{CCH}},
  \code{\link{EB.local}}, \code{\link{IC.prior}},
  \code{\link{Jeffreys}}, \code{\link{TG}},
  \code{\link{beta.prime}}, \code{\link{g.prior}},
  \code{\link{hyper.g.n}}, \code{\link{hyper.g}},
  \code{\link{intrinsic}}, \code{\link{robust}},
  \code{\link{tCCH}}
}
\author{
Merlise Clyde
}
