% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/client.R
\name{storage_endpoint}
\alias{storage_endpoint}
\alias{endpoint}
\alias{blob_endpoint}
\alias{file_endpoint}
\alias{queue_endpoint}
\alias{table_endpoint}
\alias{adls_endpoint}
\alias{print.storage_endpoint}
\alias{print.adls_endpoint}
\title{Create a storage endpoint object}
\usage{
storage_endpoint(endpoint, key = NULL, sas = NULL,
  api_version = getOption("azure_storage_api_version"))

blob_endpoint(endpoint, key = NULL, sas = NULL,
  api_version = getOption("azure_storage_api_version"))

file_endpoint(endpoint, key = NULL, sas = NULL,
  api_version = getOption("azure_storage_api_version"))

adls_endpoint(endpoint, key = NULL, sas = NULL,
  api_version = getOption("azure_adls_api_version"))

\method{print}{storage_endpoint}(x, ...)

\method{print}{adls_endpoint}(x, ...)
}
\arguments{
\item{endpoint}{The URL (hostname) for the endpoint. This must be of the form \code{http[s]://{account-name}.{type}.{core-host-name}}, where \code{type} is one of \code{"dfs"} (corresponding to ADLSgen2), \code{"blob"}, \code{"file"}, \code{"queue"} or \code{"table"}. On the public Azure cloud, endpoints will be of the form \code{https://{account-name}.{type}.core.windows.net}.}

\item{key}{The access key for the storage account.}

\item{sas}{A shared access signature (SAS) for the account. If \code{key} is also provided, the SAS is not used. If neither \code{key} nor \code{sas} are provided, only public (anonymous) access to the endpoint is possible. Note that authentication with a SAS is not supported by ADLSgen2.}

\item{api_version}{The storage API version to use when interacting with the host. Defaults to \code{"2018-06-17"} for the ADLSgen2 endpoint, and \code{"2018-03-28"} for the others.}

\item{x}{For the print method, a storage endpoint object.}

\item{...}{For the print method, further arguments passed to lower-level functions.}
}
\value{
\code{storage_endpoint} returns an object of S3 class \code{"adls_endpoint"}, \code{"blob_endpoint"}, \code{"file_endpoint"}, \code{"queue_endpoint"} or \code{"table_endpoint"} depending on the type of endpoint. All of these also inherit from class \code{"storage_endpoint"}. \code{adls_endpoint}, \code{blob_endpoint} and \code{file_endpoint} return an object of the respective class.

Currently AzureStor only includes methods for interacting with ADLSgen2 (experimental), blob and file storage.

Currently (as of December 2018), if the storage account has hierarchical namespaces enabled, the blob API for the account is disabled. The blob endpoint is still accessible, but blob operations on the endpoint will fail. Full interoperability between blobs and ADLS is planned for 2019.
}
\description{
Create a storage endpoint object, for interacting with blob, file, table, queue or ADLSgen2 storage. Currently (as of December 2018) ADLSgen2 is in general-access public preview.
}
\details{
This is the starting point for the client-side storage interface in AzureRMR. \code{storage_endpoint} is a generic function to create an endpoint for any type of Azure storage while \code{adls_endpoint}, \code{blob_endpoint} and \code{file_endpoint} create endpoints for those types.
}
\examples{
\dontrun{

# obtaining an endpoint from the storage account resource object
endp <- stor$get_blob_endpoint()

# creating an endpoint standalone
endp <- blob_endpoint("https://mystorage.blob.core.windows.net/", key="access_key")

}
}
\seealso{
\link{create_storage_account}, \link{adls_filesystem}, \link{create_adls_filesystem}, \link{file_share}, \link{create_file_share}, \link{blob_container}, \link{create_blob_container}
}
