% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{named_list}
\alias{named_list}
\alias{is_url}
\alias{is_empty}
\alias{get_paged_list}
\title{Miscellaneous utility functions}
\usage{
named_list(lst = NULL, name_fields = "name")

is_url(x, https_only = FALSE)

is_empty(x)

get_paged_list(lst, token, next_link_name = "nextLink", value_name = "value")
}
\arguments{
\item{lst}{A named list of objects.}

\item{name_fields}{The components of the objects in \code{lst}, to be used as names.}

\item{x}{For \code{is_url} and \code{is_empty}, An R object.}

\item{https_only}{For \code{is_url}, whether to allow only HTTPS URLs.}

\item{token}{For \code{get_paged_list}, an Azure OAuth token, of class \link{AzureToken}.}

\item{next_link_name, value_name}{For \code{get_paged_list}, the names of the next link and value components in the \code{lst} argument. The default values are correct for Resource Manager.}
}
\value{
For \code{named_list}, the list that was passed in but with names. An empty input results in a \emph{named list} output: a list of length 0, with a \code{names} attribute.

For \code{get_paged_list}, a list.

For \code{is_url}, whether the object appears to be a URL (is character of length 1, and starts with the string \code{"http"}). Optionally, restricts the check to HTTPS URLs only. For \code{is_empty}, whether the length of the object is zero (this includes the special case of \code{NULL}).
}
\description{
Miscellaneous utility functions
}
\details{
\code{named_list} extracts from each object in \code{lst}, the components named by \code{name_fields}. It then constructs names for \code{lst} from these components, separated by a \code{"/"}.

\code{get_paged_list} reconstructs a complete list of objects from a paged response. Many Resource Manager list operations will return \emph{paged} output, that is, the response contains a subset of all items, along with a URL to query to retrieve the next subset. \code{get_paged_list} retrieves each subset and returns all items in a single list.
}
