% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kubernetes_cluster.R
\docType{class}
\name{KubernetesCluster}
\alias{KubernetesCluster}
\title{Kubernetes cluster class}
\description{
Class representing a \href{https://kubernetes.io/docs/home/}{Kubernetes} cluster. Note that this class can be used to interface with any Docker registry that supports the HTTP V2 API, not just those created via the Azure Container Registry service. Use the \link{kubernetes_cluster} function to instantiate new objects of this class.
}
\section{Methods}{

The following methods are available, in addition to those provided by the \link[AzureRMR:az_resource]{AzureRMR::az_resource} class:
\itemize{
\item \code{new(...)}: Initialize a new registry object. See 'Initialization' below.
\item \code{create_registry_secret(registry, secret_name, email)}: Provide authentication secret for a Docker registry. See 'Secrets' below.
\item \code{delete_registry_secret(secret_name)}: Delete a registry authentication secret.
\item \code{create(file, ...)}: Creates a deployment or service from a file, using \verb{kubectl create -f}.
\item \code{get(type, ...)}: Get information about resources, using \verb{kubectl get}.
\item \code{run(name, image, ...)}: Run an image using \verb{kubectl run --image}.
\item \code{expose(name, type, file, ...)}: Expose a service using \verb{kubectl expose}. If the \code{file} argument is provided, read service information from there.
\item \code{delete(type, name, file, ...)}: Delete a resource (deployment or service) using \verb{kubectl delete}. If the \code{file} argument is provided, read resource information from there.
\item \code{apply(file, ...)}: Apply a configuration file, using \verb{kubectl apply -f}.
\item \code{show_dashboard(port, ...)}: Display the cluster dashboard. By default, use local port 30000.
\item \code{kubectl(cmd, ...)}: Run an arbitrary \code{kubectl} command on this cluster. Called by the other methods above.
\item \code{helm(cmd, ...)}: Run a \code{helm} command on this cluster.
}
}

\section{Initialization}{

The \code{new()} method takes one argument: \code{config}, the name of the file containing the configuration details for the cluster. This should be a YAML or JSON file in the standard Kubernetes configuration format. Set this to NULL to use the default \verb{~/.kube/config} file.
}

\section{Secrets}{

The recommended way to allow a cluster to authenticate with a Docker registry is to give its service principal the appropriate role-based access. However, you can also authenticate with a username and password. To do this, call the \code{create_registry_secret} method with the following arguments:
\itemize{
\item \code{registry}: An object of class either \link{acr} representing an Azure Container Registry service, or \link{DockerRegistry} representing the registry itself.
\item \code{secret_name}: The name to give the secret. Defaults to the name of the registry server.
\item \code{email}: The email address for the Docker registry.
}
}

\section{Kubectl and helm}{

The methods for this class call the \code{kubectl} and \code{helm} commandline tools, passing the \code{--config} option to specify the configuration information for the cluster. This allows all the features supported by Kubernetes to be available immediately and with a minimum of effort, although it does require that the tools be installed. The returned object from a call to \code{kubectl} or \code{helm} will contain the following components:
\itemize{
\item \code{status}: The exit status. If this is \code{NA}, then the process was killed and had no exit status.
\item \code{stdout}: The standard output of the command, in a character scalar.
\item \code{stderr}: The standard error of the command, in a character scalar.
\item \code{timeout}: Whether the process was killed because of a timeout.
\item \code{cmdline}: The command line.
}

The first four components are from \code{processx::run}; AzureContainers adds the last to make it easier to construct scripts that can be run outside R.
}

\examples{
\dontrun{

rg <- AzureRMR::get_azure_login()$
    get_subscription("subscription_id")$
    get_resource_group("rgname")

# get the cluster endpoint
kubclus <- rg$get_aks("mycluster")$get_cluster()

# get registry authentication secret
kubclus$create_registry_secret(rg$get_acr("myregistry"))

# deploy a service
kubclus$create("deployment.yaml")

# deploy a service from an Internet URL
kubclus$create("https://example.com/deployment.yaml")

# can also supply the deployment parameters inline
kubclus$create("
apiVersion: extensions/v1beta1
kind: Deployment
metadata:
  name: model1
spec:
  replicas: 1
  template:
    metadata:
      labels:
        app: model1
    spec:
      containers:
      - name: model1
        image: myregistry.azurecr.io/model1
        ports:
        - containerPort: 8000
      imagePullSecrets:
      - name: myregistry.azurecr.io
---
apiVersion: v1
kind: Service
metadata:
  name: model1-svc
spec:
  selector:
    app: model1
  type: LoadBalancer
  ports:
  - protocol: TCP
    port: 8000")

# track status
kubclus$get("deployment")
kubclus$get("service")

}
}
\seealso{
\link{aks}, \link{call_kubectl}, \link{call_helm}

\href{https://kubernetes.io/docs/reference/generated/kubectl/kubectl-commands}{Kubectl commandline reference}
}
