% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docker_registry.R
\name{docker_registry}
\alias{docker_registry}
\title{Create a new Docker registry object}
\usage{
docker_registry(server, tenant = "common", username = NULL,
  password = NULL, app = .az_cli_app_id, ..., domain = "azurecr.io",
  token = NULL, login = TRUE)
}
\arguments{
\item{server}{The registry server. This can be a URL ("https://myregistry.azurecr.io") or a domain name label ("myregistry"); if the latter, the value of the \code{domain} argument is appended to obtain the full hostname.}

\item{tenant, username, password, app, ...}{Authentication arguments to \link[AzureAuth:get_azure_token]{AzureAuth::get_azure_token}. See 'Details' below.}

\item{domain}{The default domain for the registry server.}

\item{token}{An OAuth token, of class \link[AzureAuth:AzureToken]{AzureAuth::AzureToken}. If supplied, the authentication details for the registry will be inferred from this.}

\item{login}{Whether to perform a local login (requires that you have Docker installed). This is necessary if you want to push or pull images.}
}
\value{
An R6 object of class \code{DockerRegistry}.
}
\description{
Create a new Docker registry object
}
\details{
There are two ways to authenticate with an Azure Docker registry: via Azure Active Directory (AAD), or with a username and password. The latter is simpler, while the former is more complex but also more flexible and secure.

The default method of authenticating is via AAD. Without any arguments, \code{docker_registry} will authenticate using the AAD credentials of the currently logged-in user. You can change this by supplying the appropriate arguments to \code{docker_registry}, which will be passed to \code{AzureAuth::get_azure_token}; alternatively, you can provide an existing token object.

To authenticate via the admin user account, set \code{app=NULL} and supply the admin username and password in the corresponding arguments. Note that for this to work, the registry must have been created with the admin account enabled.

Authenticating with a service principal can be done either indirectly via AAD, or via a username and password. See the examples below. The latter method is recommended, as it is both faster and allows easier interoperability with AKS and ACI.
}
\examples{
\dontrun{

# connect to the Docker registry 'myregistry.azurecr.io', authenticating as the current user
docker_registry("myregistry")

# same, but providing a full URL
docker_registry("https://myregistry.azurecr.io")

# authenticating via the admin account
docker_registry("myregistry", username="admin", password="password", app=NULL)

# authenticating with a service principal, method 1: recommended
docker_registry("myregistry", username="app_id", password="client_creds", app=NULL)

# authenticating with a service principal, method 2
docker_registry("myregistry", app="app_id", password="client_creds")

# authenticating from a managed service identity (MSI)
token <- AzureAuth::get_managed_token("https://management.azure.com/")
docker_registry("myregistry", token=token)

# you can also interact with a registry outside Azure
# note that some registry methods, and AAD authentication, may not work in this case
docker_registry("https://hub.docker.com", username="mydockerid", password="password", app=NULL)

}
}
\seealso{
\link{DockerRegistry} for methods available for interacting with the registry, \link{call_docker}

\link{kubernetes_cluster} for the corresponding function to create a Kubernetes cluster object
}
