% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_acr_methods.R
\name{create_acr}
\alias{create_acr}
\title{Create Azure Container Registry (ACR)}
\description{
Method for the \link[AzureRMR:az_resource_group]{AzureRMR::az_resource_group} class.
}
\section{Usage}{
\preformatted{create_acr(name, location = self$location,
           admin_user_enabled = TRUE, sku = "Standard", ...)
}
}

\section{Arguments}{

\itemize{
\item \code{name}: The name of the container registry.
\item \code{location}: The location/region in which to create the container registry. Defaults to this resource group's location.
\item \code{admin_user_enabled}: Whether to enable the Admin user. Currently this must be TRUE to allow Docker to access the registry.
\item \code{sku}: Either "Basic", "Standard" (the default) or "Premium".
\item \code{wait}: Whether to wait until the ACR resource provisioning is complete.
\item \code{...}: Other named arguments to pass to the \link{az_resource} initialization function.
}
}

\section{Details}{

An ACR resource is a Docker registry hosted in Azure. See the \href{https://docs.microsoft.com/en-us/azure/container-registry/}{documentation for the resource} for more information. To work with the registry (transfer images, retag images, etc) see the \link[=docker_registry]{documentation for the registry endpoint}.
}

\section{Value}{

An object of class \code{az_container_registry} representing the registry resource.
}

\examples{
\dontrun{

rg <- AzureRMR::get_azure_login()$
    get_subscription("subscription_id")$
    get_resource_group("rgname")

rg$create_acr("myregistry")

}
}
\seealso{
\link{get_acr}, \link{delete_acr}, \link{list_acrs}

\link{az_container_registry}

\link{docker_registry} for the registry endpoint

\href{https://docs.microsoft.com/en-us/azure/container-registry/}{ACR documentation} and
\href{https://docs.microsoft.com/en-us/rest/api/containerregistry/registries}{API reference}

\href{https://docs.docker.com/registry/spec/api/}{Docker registry API}
}
