% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mathematicalfunctions.R
\name{parallelaxis}
\alias{parallelaxis}
\title{Parallel axis theory}
\usage{
parallelaxis(I, offset_vec, m, cg_a)
}
\arguments{
\item{I}{a 3x3 matrix representing the moment of inertia tensor about the
center of gravity of the object (kg-m^2).}

\item{offset_vec}{a 1x3 vector representing the distance (x,y,z) between
the objects CG and the arbitrary pt A (m).
Vector should always point from the CG to the arbitrary point A.}

\item{m}{Mass of the object (kg).}

\item{cg_a}{If input I is about the CG enter "CG" or if I is about an
arbitrary axis enter "A".}
}
\value{
a 3x3 matrix representing the transformed moment of inertia tensor
after a solid body translation defined by the offset vector.
}
\description{
Reads in an initial tensor and an offset to compute the transformed tensor.
Will be in the same frame of reference as the input tensor.
}
\examples{
# refer to the vignette
library(AvInertia)

# load data
data(dat_id_curr, package = "AvInertia")
data(dat_bird_curr, package = "AvInertia")
data(dat_feat_curr, package = "AvInertia")
data(dat_bone_curr, package = "AvInertia")
data(dat_mat, package = "AvInertia")
data(clean_pts, package = "AvInertia")

# 1. Determine the center of gravity of the bird's torso (including the legs)
dat_torsotail_out = massprop_restbody(dat_id_curr, dat_bird_curr)
# 2. Calculate the inertia of the flight feathers about the tip of the calamus
feather_inertia <- compute_feat_inertia(dat_mat, dat_feat_curr, dat_bird_curr)
# 3. Determine the center of gravity of one of the bird's wings
dat_wing_out      = massprop_birdwing(dat_id_curr, dat_bird_curr,
dat_bone_curr, dat_feat_curr, dat_mat, clean_pts,
feather_inertia, plot_var = 0)
# Visualize the center of gravity of each wing component in the x and y axis
dat_wing_out      = massprop_birdwing(dat_id_curr, dat_bird_curr,
dat_bone_curr, dat_feat_curr, dat_mat, clean_pts,
feather_inertia, plot_var = "yx")
# or the y and z axis
dat_wing_out      = massprop_birdwing(dat_id_curr, dat_bird_curr,
dat_bone_curr, dat_feat_curr, dat_mat, clean_pts,
feather_inertia, plot_var = "yz")
# 4. Combine all data and obtain the center of gravity, moment of inertia
# and principal axes of the bird
curr_full_bird      = combine_inertialprop(dat_torsotail_out,dat_wing_out,
dat_wing_out, dat_id_curr, dat_bird_curr, symmetric=TRUE)

}
\author{
Christina Harvey
}
