% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AutoScore_Survival.R
\name{plot_survival_km}
\alias{plot_survival_km}
\title{AutoScore function for survival outcomes: Print scoring performance (KM curve)}
\usage{
plot_survival_km(
  pred_score,
  score_cut = c(40, 50, 60),
  risk.table = TRUE,
  title = NULL,
  legend.title = "Score",
  xlim = c(0, 90),
  break.x.by = 30,
  ...
)
}
\arguments{
\item{pred_score}{Generated from STEP(v)\code{AutoScore_testing_Survival()}}

\item{score_cut}{Score cut-offs to be used for the analysis}

\item{risk.table}{Allowed values include: TRUE or FALSE specifying whether
to show or not the risk table. Default is TRUE.}

\item{title}{Title displayed in the KM curve}

\item{legend.title}{Legend title displayed in the KM curve}

\item{xlim}{limit for x}

\item{break.x.by}{Threshold for analyze sensitivity,}

\item{...}{additional parameters to pass to
\code{\link[survminer]{ggsurvplot}} .}
}
\value{
No return value and the KM performance will be plotted.
}
\description{
Print scoring performance (KM curve) for survival outcome
}
\seealso{
\code{\link{AutoScore_testing_Survival}}
}
