% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AsyK.R
\name{compLR}
\alias{compLR}
\title{Plot Density by RIG and Laplace kernel.}
\usage{
compLR(y, k, h)
}
\arguments{
\item{y}{a numeric vector of positive values.}

\item{k}{gird points.}

\item{h}{the bandwidth}
}
\description{
Plot densities by using Resiprocal Inverse Gaussian and Laplace Kernel.
}
\details{
It plot the densities by Laplace, RIG kernel and with real density at the same time.
}
\examples{
y<-rexp(100,1)
h<-0.79 * IQR(y) * length(y) ^ (-1/5)
compLR(y,80,h)
}
\references{
\itemize{
\item Khan, J. A.; Akbar, A. Density Estimation by Laplace Kernel. \emph{Working paper,  Department of Statistics, Bahauddin Zakariya University, Multan, Pakistan.}
\item Scaillet, O. 2004. Density estimation using inverse and reciprocal inverse Gaussian kernels. 	 \emph{Nonparametric Statistics}, \strong{16}, 217-226.
}
}
\author{
Javaria Ahmad Khan, Atif Akbar.
}
