% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AsyK.R
\name{mseRIG}
\alias{mseRIG}
\title{Calculate Mean Squared Error( MSE) when RIG kernel is used.}
\usage{
mseRIG(y, k, h, type)
}
\arguments{
\item{y}{a numeric vector of positive values.}

\item{k}{gird points.}

\item{h}{the bandwidth}

\item{type}{mention distribution of vector.If exponential distribution then use "Exp".
if use gamma distribution then use "Gamma".If Weibull distribution then use "Weibull".}
}
\value{
MSE
}
\description{
Calculate MSE by using Resiprocal Inverse Gaussian Kernel.
}
\examples{
y<-rexp(100,1)
h<-0.79 * IQR(y) * length(y) ^ (-1/5)
mseRIG(y,200,h,"Exp")
}
\references{
Scaillet, O. 2004. Density estimation using inverse and reciprocal inverse Gaussian kernels. 	 \emph{Nonparametric Statistics}, \strong{16}, 217-226.
}
\seealso{
For further MSE by using Laplace kernel see \code{\link{mseLap}}. For density estimation by using RIG Kernel \code{\link{plot.RIG}} and for estimated values
of density \code{\link{RIG}}.
}
