% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tactical_DualMomentum.R
\name{tactical_DualMomentum}
\alias{tactical_DualMomentum}
\title{Returns allocations for the dual momentum strategy on a given date}
\usage{
tactical_DualMomentum(strat, reb_date, P, R, risk_free)
}
\arguments{
\item{strat}{A list representing an asset allocation strategy. For this
particular strategy, \code{strat$asset_class} must contain a character vector
containing the corresponding asset classes.}

\item{reb_date}{A date on which the allocation rule is applied.}

\item{P}{An xts object with daily prices of the tickers in strat.}

\item{R}{An xts object with daily returns of the tickers in strat.}

\item{risk_free}{Either an xts object with daily returns of the risk-free
asset, or a scalar numeric with the annual risk-free rate in decimals.}
}
\value{
A numeric vector of weights after applying the rule.
}
\description{
\code{tactical_DualMomentum} determines asset allocations for a strategy
according to the dual momentum approach described in Antonacci (2016)
<doi:https://dx.doi.org/10.2139/ssrn.2042750>.
}
\details{
Dual momentum sorts assets within each asset class described in \code{strat}
on a relative basis (i.e. which asset outperforms others within the same
asset class) over the last 12 months, as well as whether an asset has
positive excess return over the last 12 months. Dual momentum invests in the
top performing asset within the asset class, as long as it also has positive
excess return over the risk-free rate. Otherwise, the allocation is shifted
to the risk-free asset.
Any amounts not allocated to risky assets are allocated to the risk-free
asset as implemented in the \code{backtest_allocation} function.
}
\examples{
dual_mom  <- asset_allocations$tactical$dual_mom
reb_date <- as.Date("2022-03-31")
tactical_DualMomentum(dual_mom,
             reb_date,
             ETFs$Prices[, dual_mom$tickers],
             ETFs$Returns[, dual_mom$tickers],
             ETFs$risk_free)
}
