% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/undated_sample.R
\name{undated_sample}
\alias{undated_sample}
\title{Predictive distribution of date}
\usage{
undated_sample(data1, data2, level = 0.95)
}
\arguments{
\item{data1}{Numeric vector containing the output of the MCMC algorithm
for the begining of interval}

\item{data2}{Numeric vector containing the output of the MCMC algorithm
for the end of interval}

\item{level}{Probability corresponding to the desired level of confidence.
@return A list with the following components:}
}
\description{
Predictive distribution of date
}
\details{
Simulate the sample from the predictive distribution of an undated sample
in stratigraphic constraint between two dates. The input is an MCMC sample simulated
from the joint posterior distribution of these dates.
}
\examples{
  data(Phases);
  attach(Phases)
  sample = undated_sample(Phase.1.alpha,Phase.1.beta)
  # credible interval for the new date.
  sample$credible
  #time range interval
  sample$timerange
 # graphics = densities / IC / time range ggplot
   sample$gr
}
\author{
Anne Philippe, \email{Anne.Philippe@univ-nantes.fr} and
\describe{
\item{TR}{ time range to characterize the period defied by data1 and data2}
\item{ci}{ credible interval for the preditive date}
\item{mcmc}{ simulated sample from undated sample age }
\item{call}{Function call.}
}
}
