% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TempoActivityPlot.R
\name{tempo_activity_plot}
\alias{tempo_activity_plot}
\title{Plot the derivative of the tempo plot Bayesian estimate}
\usage{
tempo_activity_plot(
  data,
  position = 1:ncol(data),
  title = "Tempo Activity Plot",
  subtitle = NULL,
  caption = "ArcheoPhases",
  x_label = "Calendar year",
  y_label = "Activity",
  line_types = c("solid"),
  width = 7,
  height = 7,
  units = "in",
  x_min = NULL,
  x_max = NULL,
  file = NULL,
  x_scale = "calendar",
  elapsed_origin_position = NULL,
  new_window = TRUE,
  plot_result = TRUE
)
}
\arguments{
\item{data}{Data frame containing the output of the MCMC algorithm.}

\item{position}{Numeric vector containing the position of the column
corresponding to the MCMC chains of interest, or a vector of column names.}

\item{title}{Title of the plot.}

\item{subtitle}{Subtitle of the plot.}

\item{caption}{Caption of the plot.}

\item{x_label}{Label of the x-axis.}

\item{y_label}{Label of the y-axis.}

\item{line_types}{Type of the lines drawn on the plot.}

\item{width}{Width of the plot in \code{units}.}

\item{height}{Height of the plot in \code{units}.}

\item{units}{Units used to specify \code{width} and \code{height},
one of "in" (default),"cm", or "mm".}

\item{x_min}{Minimum value for x-axis.}

\item{x_max}{Maximum value for x-axis.}

\item{file}{Name of the file to be saved if specified.
If \code{Null}, then no file is saved.}

\item{x_scale}{One of "calendar", "bp", or "elapsed".}

\item{elapsed_origin_position}{If \code{x_scale} is "elapsed", the position
of the column corresponding to the event from which elapsed time is calculated.}

\item{new_window}{Whether or not the plot is drawn within a new window.}

\item{plot_result}{If \code{TRUE}, then draw a plot on the display,
else suppress drawing.}
}
\value{
An \code{archaeophases_plot} object with the data and metadata
needed to reproduce the plot.
}
\description{
A statistical graphic designed for the archaeological study of rhythms of
the long term that embodies a theory of archaeological evidence for the
occurrence of events
}
\examples{
  data(Events);
  tempo_activity_plot(Events[1:1000, ], c(2:5))

}
\references{
Dye, T.S. (2016) Long-term rhythms in the development of Hawaiian social stratification.
Journal of Archaeological Science, 71, 1--9.
}
\author{
Anne Philippe, \email{Anne.Philippe@univ-nantes.fr} and

Marie-Anne Vibet, \email{Marie-Anne.Vibet@univ-nantes.fr}

Thomas S. Dye, \email{tsd@tsdye.online}
}
