% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3Classes.R
\name{reproduce.archaeophases_plot}
\alias{reproduce.archaeophases_plot}
\title{Reproduce an ArchaeoPhases plot}
\usage{
\method{reproduce}{archaeophases_plot}(x, file = NULL, ...)
}
\arguments{
\item{x}{An \code{archaeophases_plot} object.}

\item{file}{Path to the original MCMC csv file, or a copy of the file.}

\item{...}{Other parameters.}
}
\description{
Reproduces a plot from metadata held in an \code{archaeophases_plot}
object.
}
\examples{
\dontrun{
x <- read_bcal("http://tsdye.online/AP/bc-1.csv")
y <- multi_dates_plot(x)
z <- reproduce(y)
# TRUE
identical(y, z)

#ERROR, Not the original file.
z <- reproduce(y, file = "foo.csv")
}

}
\seealso{
\code{\link{original_file}}
}
\author{
Thomas S. Dye, \email{tsd@tsdye.online}
}
