% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prog.R
\name{ImportCSV.BCal}
\alias{ImportCSV.BCal}
\title{Importing a BCal csv file}
\usage{
  ImportCSV.BCal(file, bin.width=NULL)
}
\arguments{
  \item{file}{the name of the CSV file containing the output of the MCMC algorithm}
  \item{bin.width}{the bin width specified in a BCal project. Note that bin.width does not have to be set if the BCal default bin width of 1 is used.}
}
\value{
  Returns a data frame (data.frame) containing a representation of the data in the file. MCMC should now be in date format BC/AD. 
}
\description{
  Importing a csv file containing the output of the MCMC algorithm from the BCal software. MCMC generated by BCal software are in date format cal BP.
  }
\author{
    Anne Philippe <Anne.Philippe@univ-nantes.fr>, Thomas S. Dye  <TSD@tsdye.com> and

  Marie-Anne Vibet <Marie-Anne.Vibet@univ-nantes.fr>
}
\examples{

  # Import of MCMC generated by BCal and extracted in cal BP (the year of reference is 1950)
  data(Fishpond)
  write.csv(Fishpond, "fishpond_MCMC.csv", row.names=FALSE)
  Fishpond = ImportCSV.BCal("fishpond_MCMC.csv", bin.width=1)
  # equivalent to 
  #Fishpond2 = ImportCSV("fishpond_MCMC.csv", dec = '.', sep=',',referenceYear = 1950, 
  #rowToWithdraw = "last", bin.width=1)
}
\keyword{CSV file}
