% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output_function.R
\name{deltaG_F}
\alias{deltaG_F}
\title{Calculating genetic gain and rate of inbreeding}
\usage{
deltaG_F(
  Ntraits = BPdata$Ntraits,
  startgen = c(rep(2, times = Ntraits)),
  endgen = c(rep(max(ped$generation), times = Ntraits)),
  endgenF = max(ped$generation)
)
}
\arguments{
\item{Ntraits}{The number of simulated traits. Does not need to be specified if Ntraits is in the list 'BPdata'.}

\item{startgen}{The first generation from which the (average) genetic gain per generation needs to be calculated. By default, this is generation 2 for each trait.}

\item{endgen}{The last generation that needs to be included in the calculation of the (average) genetic gain per generation. By default, this is the last simulated generation for each trait.}

\item{endgenF}{The last generation that needs to be included in the calculateion of the rate of inbreeding. This is by default the last simulated generation for each trait.}
}
\value{
A data frame with the rate of inbreeding and the genetic gain for each trait.
}
\description{
This function can be used to calculate the genetic gain per generation for each trait and the rate of inbreeding from the output of the breeding program simulations (pedigree needs to be called ped).
Rate of inbreeding is calculated from the first simulated generation till the last generation, unless a different end generation is specified.
Genetic gain is an average genetic gain per generation, calculated over multiple generations.
}
\examples{
\dontrun{
deltaG_F()
}
}
