% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic.r
\name{write.AmigaBasicShape}
\alias{write.AmigaBasicShape}
\title{Write an AmigaBasicShape object to a file}
\usage{
write.AmigaBasicShape(x, file)
}
\arguments{
\item{x}{The \code{\link[=AmigaBasicShape]{AmigaBasicShape()}} class object that needs to be
stored.}

\item{file}{A \code{character} string specifying the file location
to which \code{x} (an \code{\link[=AmigaBasicShape]{AmigaBasicShape()}} object) needs to be written.}
}
\value{
Invisibly returns the result of the call of \code{close} to the
file connection.
}
\description{
Write an \code{\link[=AmigaBasicShape]{AmigaBasicShape()}} class object to a file in its binary format.
}
\details{
This function coerces the Amiga Basic Shape into its binary format
(using \code{\link[=as.raw]{as.raw()}}) and writes it to a file. The file
can also be stored onto a virtual Amiga disk
(\code{\link[adfExplorer:adf_file_con]{adf_file_con()}}).
}
\examples{
filename <- system.file("ball.shp", package = "AmigaFFH")
ball     <- read.AmigaBasicShape(filename)
write.AmigaBasicShape(ball, file.path(tempdir(), "ball.shp"))
}
\seealso{
Other AmigaBasicShape.operations: 
\code{\link{AmigaBasicShape}},
\code{\link{rasterToAmigaBasicShape}()},
\code{\link{read.AmigaBasicShape}()}

Other io.operations: 
\code{\link{read.AmigaBasicBMAP}()},
\code{\link{read.AmigaBasicShape}()},
\code{\link{read.AmigaBasic}()},
\code{\link{read.AmigaBitmapFontSet}()},
\code{\link{read.AmigaBitmapFont}()},
\code{\link{read.AmigaIcon}()},
\code{\link{read.SysConfig}()},
\code{\link{read.iff}()},
\code{\link{write.AmigaBasic}()},
\code{\link{write.AmigaBitmapFont}()},
\code{\link{write.AmigaIcon}()},
\code{\link{write.SysConfig}()},
\code{\link{write.iff}()}
}
\author{
Pepijn de Vries
}
\concept{AmigaBasicShape.operations}
\concept{io.operations}
