% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iff.8svx.r
\docType{methods}
\name{play}
\alias{play}
\alias{play,ANY-method}
\alias{play}
\alias{play,IFFChunk-method}
\title{Playing Amiga audio data}
\usage{
\S4method{play}{ANY}(object, player = NULL, ...)

\S4method{play}{IFFChunk}(object, player = NULL, ...)
}
\arguments{
\item{object}{An \code{\link{IFFChunk-class}} object that needs to be played. The \code{\link{IFFChunk}}
should be of type FORM, containing an 8SVX chunk, or an 8SVX itself. \code{object} can also be of class
\code{IFF.FORM} or \code{IFF.8SVX}. See \code{\link[tuneR]{play}} for other objects that can be played.}

\item{player}{Path to the external audio player. See \code{\link[tuneR]{play}} for more details.}

\item{...}{Arguments passed onto the tuneR \code{\link{play}} routine.}
}
\value{
Returns a list of data returned by tuneR's \code{\link[tuneR]{play}}, for which the output
is undocumented.
}
\description{
A wrapper for \code{\link{tuneR}}-package's \code{\link[tuneR]{play}} routine. Allowing it to play
Amiga audio (for instance stored in an 8SVX Interchange File Format).
}
\details{
A wrapper for \code{\link{tuneR}}-package's \code{\link[tuneR]{play}} routine. It will try to play
audio using an external audio player. When 8SVX audio is played, each octave is played separately.
When a FORM container contains multiple 8SVX samples, they are also played successively.

Note that a separate package is developed to interpret and play ProTracker modules and samples
(\code{\link{ProTrackR}}).
}
\examples{
\dontrun{
## First get an audio sample from the ProTrackR package
snare.samp <- ProTrackR::PTSample(ProTrackR::mod.intro, 2)

## Coerce it into an IFFChunk object:
snare.iff <- WaveToIFF(snare.samp)

## Play the 8SVX sample:
play(snare.iff)
}
}
\author{
Pepijn de Vries
}
