% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{lrt.A}
\alias{lrt.A}
\title{likelihood ratio test for two models based on kstest.A}
\usage{
lrt.A(d1, d2, parallel = FALSE)
}
\arguments{
\item{d1}{An object of class 'kstest.A'.}

\item{d2}{An object of class 'kstest.A'.}

\item{parallel}{Whether to use multiple threads to paralleling computation. Default is FALSE. Please aware that it may take longer time to execute the program with parallel=FALSE.}
}
\value{
The p-value of the likelihood ratio test.
}
\description{
Conduct likelihood ratio test for comparing two different models.
}
\details{
If the pvalue of d1 and d2 are greater than the user-specified significance level, which indicates that the original data x may come from the two distributions in d1 and d2, a likelihood ratio test is desired to choose a more 'possible' distribution based on the current data.
NOTE that the x in d1 and d2 must be IDENTICAL! Besides, NOTE that the dist in d1 and d2 must be DIFFERENT!
The dist inherited from d1 is the null distribution and that from d2 is used as the alternative distribution.

If the output p-value smaller than the user-specified significance level, the dist of d2 is more appropriate for modeling x.
Otherwise, There is no significant difference between dist of d1 and dist of d2, given the current data.
}
\examples{
set.seed(1005)
x=sample.h1(2000,phi=0.3,dist='poisson',lambda=10)
d1=kstest.A(x,nsim=100,bootstrap = TRUE,dist= 'ph',lowerbound = 1e-10, upperbound = 100000)
d2=kstest.A(x,nsim=100,bootstrap = TRUE,dist= 'geomh',lowerbound = 1e-10, upperbound = 100000)
lrt.A(d1,d2) #0.28
}
\seealso{
\link[AZIAD]{lrt.B}
}
