% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/kms.R
\name{kms_encrypt}
\alias{kms_encrypt}
\title{Encrypt plain text via KMS}
\usage{
kms_encrypt(key, text)
}
\arguments{
\item{key}{the KMS customer master key identifier as a fully specified Amazon Resource Name (eg \code{arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012}) or an alias with the \code{alias/} prefix (eg \code{alias/foobar})}

\item{text}{max 4096 bytes long character vector, eg an RSA key, a database password, or other sensitive customer information}
}
\value{
Base64-encoded text
}
\description{
Encrypt plain text via KMS
}
\examples{
\dontrun{
kms_encrypt('alias/mykey', 'foobar')
}
}
\references{
\url{http://docs.aws.amazon.com/AWSJavaSDK/latest/javadoc/com/amazonaws/services/kms/AWSKMSClient.html#encrypt-com.amazonaws.services.kms.model.EncryptRequest-}
}
\seealso{
kms_decrypt
}

