% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{wilcoxon}
\alias{wilcoxon}
\title{Compute the standardized Wilcoxon test statistic for two samples}
\usage{
wilcoxon(x, y, theta = 0)
}
\arguments{
\item{x}{a sample numeric vector}

\item{y}{a sample numeric vector}

\item{theta}{a value > 0 but < 1/2.}
}
\value{
the standardized Wilcoxon statistic
}
\description{
We compute the standardized Wilcoxon test statistic with mean 0 and
and standard deviation 1 for samples \eqn{x} and \eqn{y}.  The R function
\code{\link[stats:wilcox.test]{stats::wilcox.test()}} returns the statistic
}
\details{
\deqn{
U = \sum_i R_i - \frac{m(m + 1)}{2}
}{
U = (sum over i) R_i - m(m + 1) / 2
}

where \eqn{R_i} are the ranks of the first sample \eqn{x} of size
\eqn{m}. We compute

\deqn{
\frac{(U - mn(1/2 + \theta))}{\sqrt{mn(m + n + 1) / 12}}
}{
(U - mn(1/2 + theta)) / (mn(m + n + 1) / 12)^(1/2)
}

where \eqn{\theta} is the alternative hypothesis shift on the
probability scale, i.e. \eqn{P(X > Y) = 1/2 + \theta}.
}
