% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_wave.R
\name{clip_wave_single}
\alias{clip_wave_single}
\title{Clip single wave file}
\usage{
clip_wave_single(
  path_in,
  path_out,
  clip_length,
  start_time = 0,
  wave_length = NULL,
  overwrite = FALSE
)
}
\arguments{
\item{path_in}{Character. Path to the wave file to clip.}

\item{path_out}{Character. Path to copy the new clipped wave file to.}

\item{clip_length}{Numeric. Length of new clip in seconds.}

\item{start_time}{Numeric. Time in seconds where new clip should start.
Default 0.}

\item{wave_length}{Numeric. Length of the clipped wave file in seconds (if
\code{NULL}, default, will be the length of time from \code{start_time} to the end of
the file).}

\item{overwrite}{Logical. Whether to overwrite existing files when creating
new clipped wave files. Default (\code{FALSE}) will error if the file already
exists.}
}
\value{
TRUE if successful
}
\description{
Clip and copy a single wave files to a given length. See \code{clip_wave()} for
processing multiple files.
}
\examples{
# Create test wave file
f <- temp_wavs(1)

# Clip file and check it out
clip_wave_single(f, "new_file.wav", clip_length = 1)
tuneR::readWave("new_file.wav")
unlink("new_file.wav")
}
