% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cox.stuart.R
\name{cox.stuart}
\alias{cox.stuart}
\title{Perform Cox-Stuart test}
\usage{
cox.stuart(
  x,
  alternative = c("two.sided", "less", "greater"),
  cont.corr = TRUE,
  max.exact.cases = 1e+07,
  do.asymp = FALSE,
  do.exact = TRUE
)
}
\arguments{
\item{x}{Numeric vector}

\item{alternative}{Type of alternative hypothesis (defaults to \code{two.sided})}

\item{cont.corr}{Boolean indicating whether or not to use continuity correction (defaults to \code{TRUE})}

\item{max.exact.cases}{Maximum number of cases allowed for exact calculations (defaults to \code{10000000})}

\item{do.asymp}{Boolean indicating whether or not to perform asymptotic calculations (defaults to \code{FALSE})}

\item{do.exact}{Boolean indicating whether or not to perform exact calculations (defaults to \code{TRUE})}
}
\value{
An ANSMtest object with the results from applying the function
}
\description{
\code{cox.stuart()} performs the Cox-Stuart test and is used in chapters 4 and 10 of "Applied Nonparametric Statistical Methods" (5th edition)
}
\examples{
# Example 4.13 from "Applied Nonparametric Statistical Methods" (5th edition)
cox.stuart(ch4$precipitation)

# Exercise 10.5 from "Applied Nonparametric Statistical Methods" (5th edition)
cox.stuart(ch10$age.at.death, alternative = "less")

}
