% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ANOPA-power.R
\name{anopaN2Power}
\alias{anopaN2Power}
\alias{anopaPower2N}
\alias{anopaProp2fsq}
\title{Computing power within the ANOPA.}
\usage{
anopaPower2N(power, P, f2, alpha)

anopaN2Power(N, P, f2, alpha)

anopaProp2fsq(props, ns, unitaryAlpha, method="approximation")
}
\arguments{
\item{N}{sample size;}

\item{P}{number of groups;}

\item{f2}{effect size Cohen's $f^2$;}

\item{alpha}{(default if omitted .05) the decision threshold.}

\item{power}{target power to attain;}

\item{ns}{sample size per group;}

\item{props}{a set of expected proportions (if all between 0 and 1) or number of success per group.}

\item{method}{for computing effect size $f^2$ is 'approximation' or 'exact' only.}

\item{unitaryAlpha}{for within-subject design, the measure of correlation
across measurements.}
}
\value{
\code{anopaPower2N()} returns a sample size to reach a given power level.
\code{anopaN2Power()} returns statistical power from a given sample size.
\code{anopaProp2fsq()} returns $f^2$ the effect size from a set of proportions
and sample sizes.
}
\description{
The function 'anopaN2Power()' performs an analysis of statistical power
according to the 'ANOPA' framework. See \insertCite{lc23b;textual}{ANOPA} for more.
'anopaPower2N()' computes the sample size to reach a given power.
Finally, 'anopaProp2fsq()' computes the f^2 effect size from a set of proportions.
}
\details{
Note that for \code{anopaProp2fsq()}, the expected effect size $f^2$
depends weakly on the sample sizes. Indeed, the Anscombe transform
can reach more extreme scores when the sample sizes are larger, influencing
the expected effect size.
}
\examples{
# 1- Example of the article:
# with expected frequences .34 to .16, assuming as a first guess groups of 25 observations:
f2 <- anopaProp2fsq( c( 0.32, 0.64, 0.40, 0.16), c(25,25,25,25) );
f2
# f-square is 0.128.

# f-square can be converted to eta-square with
eta2 <- f2 / (1 + f2)


# With a total sample of 97 observations over four groups,
# statistical power is quite satisfactory (85\%).
anopaN2Power(97, 4, f2)

# 2- Power planning.
# Suppose we plan a four-classification design with expected proportions of:
pred <- c(.35, .25, .25, .15)
# P is the number of classes (here 4)
P <- length(pred)
# We compute the predicted f2 as per Eq. 5
f2 <- 2 * sum(pred * log(P * pred) )
# the result, 0.0822, is a moderate effect size.

# Finally, aiming for a power of 80\%, we run
anopaPower2N(0.80, P, f2)
# to find that a little more than 132 participants are enough.


}
\references{
\insertAllCited{}
}
