% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\name{as.mic}
\alias{as.mic}
\alias{is.mic}
\title{Class 'mic'}
\usage{
as.mic(x, na.rm = FALSE)

is.mic(x)
}
\arguments{
\item{x}{vector}

\item{na.rm}{a logical indicating whether missing values should be removed}
}
\value{
Ordered factor with new class \code{mic} and new attribute \code{package}
}
\description{
This transforms a vector to a new class \code{mic}, which is an ordered factor with valid MIC values as levels. Invalid MIC values will be translated as \code{NA} with a warning.
}
\examples{
mic_data <- as.mic(c(">=32", "1.0", "1", "1.00", 8, "<=0.128", "8", "16", "16"))
is.mic(mic_data)

# this can also coerce combined MIC/RSI values:
as.mic("<=0.002; S") # will return <=0.002

plot(mic_data)
barplot(mic_data)
freq(mic_data)
}
\seealso{
\code{\link{as.rsi}}
}
\keyword{mic}
