% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/insertAMModelLib.R
\name{insertAMModelLib}
\alias{insertAMModelLib}
\title{Insert model of class amModel or dataset of class amData into an amModelLib object.  If the amModelLib is not specified, the function will create an info-less and description-less lib if none is specified in \dots argument.}
\usage{
insertAMModelLib(models, data, amml, ...)
}
\arguments{
\item{models}{An object of class amModel}

\item{data}{An object of class amData}

\item{amml}{The name of the object that of class amModelLib.}

\item{...}{Additional arguments to be passed to the function \code{createAMModelList} which will create the the amModelLib if not specified.}
}
\value{
An object of class amModelLib
}
\description{
Inserts a model into the model slot of an amModelLib object, or inserts a dataset into the data slot of an amModelLib object.
}
\details{
If the argument amml is NULL, the function will call \code{createAMModelList} to create the object.  The argument info can be passed to this function via the \dots argument.
}
\examples{
# create dataset from lm helpfile
## Annette Dobson (1990) "An Introduction to Generalized Linear Models".
## Page 9: Plant Weight Data.
ctl <- c(4.17,5.58,5.18,6.11,4.50,4.61,5.17,4.53,5.33,5.14)
trt <- c(4.81,4.17,4.41,3.59,5.87,3.83,6.03,4.89,4.32,4.69)
group <- gl(2, 10, 20, labels = c("Ctl","Trt"))
weight <- c(ctl, trt)
lm.D9 <- lm(weight ~ group)
lm.D90 <- lm(weight ~ group - 1) # omitting intercept

# create an amData object that includes metadata
plant.data <- data.frame(group = group, weight = weight)
plant.data <- amData(data = plant.data, comment = 'Dataset from lm helpfile.')

# create an amModel object with metadata and a soft link to the data
full.model <- amModel(
    model = lm.D9,
    comment = 'full model',
    source = 'lm helpfile (R).',
    taxa = 'plants',
    data = 'plant.data'
)


# create an amModelLib that contains the amModel object and the amData object
# the model and data must be supplied as named lists
mymodels <- amModelLib(
    description = "An example amModelLib.",
    models = list(full.model = full.model),
    data = list(plant.data = plant.data)
)

# create second amModel object with metadata and a soft link to the same data
no.int.model <- amModel(
    model = lm.D90,
    comment = 'model without intercept',
    source = 'lm helpfile (R).',
    taxa = 'plants',
    data = 'plant.data'
)

# create a second amData object
log.plant.data <- data.frame(group, log.weight=log(weight))
log.plant.data <- amData(
    data = log.plant.data,
    comment = 'data to fit log model',
    source = 'lm helpfile (R).'
)

# insert the second model and second dataset to the amModelLib
mymodels <- insertAMModelLib(
    mymodels,
    models = list(no.int.model = no.int.model),
    data = list(log.plant.data = log.plant.data)
)
}
\seealso{
Other amModelLib: \code{\link{AMModels}};
  \code{\link{amData}}, \code{\link{amData-class}};
  \code{\link{amModelLib}}, \code{\link{amModelLib-class}};
  \code{\link{amModel}}, \code{\link{amModel-class}};
  \code{\link{ammlDesc}}, \code{\link{ammlDesc}},
  \code{\link{ammlDesc<-}}, \code{\link{ammlInfo}},
  \code{\link{ammlInfo}}, \code{\link{ammlInfo<-}},
  \code{\link{dataMeta}}, \code{\link{dataMeta<-}},
  \code{\link{getAMData}}, \code{\link{getAMData}},
  \code{\link{getAMModel}}, \code{\link{getters}},
  \code{\link{modelMeta}}, \code{\link{modelMeta<-}};
  \code{\link{getAMModelLib}}; \code{\link{lsData}},
  \code{\link{lsData}}, \code{\link{lsModels}},
  \code{\link{lsModels}}; \code{\link{rmData}},
  \code{\link{rmData}}, \code{\link{rmModel}}
}
\keyword{manip}

