% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AMAPVoxGenerics.R, R/AMAPVoxGetters.R
\docType{methods}
\name{getMaxCorner}
\alias{getMaxCorner}
\alias{getMaxCorner,VoxelSpace-method}
\title{Gets the x, y, z coordinates of the voxel space top right corner.}
\usage{
getMaxCorner(voxelSpace)

\S4method{getMaxCorner}{VoxelSpace}(voxelSpace)
}
\arguments{
\item{voxelSpace}{the \code{\link{VoxelSpace-class}} object.}
}
\value{
the x, y, z coordinates of the voxel space top right corner, as a
numerical vector.
}
\description{
Gets the x, y, z coordinates of the voxel space top right
corner.
}
\examples{
# load a voxel file
vox <- readVoxelSpace(system.file("extdata", "als_sample.vox", package = "AMAPVox"))
# retrieve 'max_corner' parameter
getMaxCorner(vox)
}
