% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/adapt.R
\name{adapt}
\alias{adapt}
\title{Adaptations in group sequential trials}
\usage{
adapt(pT, iD, SF, phi, cp, theta = iD$z/(pT$t[iD$T] * pT$Imax), I2min, I2max,
  swImax, delta = pT$delta, weight = 1, warn = TRUE)
}
\arguments{
\item{pT}{object of the \code{class} \code{GSTobj}; primary trial design}

\item{iD}{interim data; a list with the variables \code{T} and \code{z}; list(T = stage of interim analysis, z = interim z-statistic)}

\item{SF}{spending function for the secondary trial}

\item{phi}{parameter of spending function for the secondary trial when SF=3 or 4 (See below)}

\item{cp}{conditional power}

\item{theta}{new effect size (default: estimate from interim analysis)}

\item{I2min}{minimal total information of secondary trial}

\item{I2max}{maximal total information of secondary trial}

\item{swImax}{maximal incremental information per stage}

\item{delta}{initially assumed effect size for the primary trial (default: estimate from primary trial)}

\item{weight}{weight of \code{theta} when updating the effect size estimate as weighted mean of \code{theta} and \code{delta}}

\item{warn}{option if warnings should be printed to the screen (default: true)}
}
\value{
\code{adapt} returns an object of the \code{class} \code{GSTobj}; the design of the secondary trial. The adaptation rule is as in the first simulation example of Brannath et al.(2008). If no adaptations are performed, the function returns \code{sT} = NULL. An object of \code{class} \code{GSTobj} is a list containing the following components: \item{sT}{ secondary trial}
}
\description{
\code{adapt} is a function that performs adaptations and plans the secondary group sequential trial. The
effect size used for planning the secondary trial is a weighted mean between the interim estimate \code{theta} and
the initially assumed estimate \code{delta} (pT\$delta) of the primary trial.
}
\details{
If no adaptation is performed then this indicates that the original plan is kept. In this case \code{sT} is set to \code{NULL}.
If an adaptation is performed \code{sT} is a list which contains the following elements:
\tabular{ll}{
   \code{K}\tab number of stages\cr
   \code{a}\tab lower critical bounds of secondary group sequential design(are currently always set to -8)\cr
   \code{b}\tab upper critical bounds of secondary group sequential design\cr
   \code{t}\tab vector with cumulative information fractions\cr
   \code{al}\tab alpha (type I error rate); equal to the conditional type I error rate of the primary trial\cr
   \code{SF}\tab spending function\cr
   \code{phi}\tab parameter of spending function when SF=3 or 4 (See below)\cr
   \code{alab}\tab alpha-absorbing parameter values of secondary group sequential design\cr
   \code{als}\tab alpha-values ''spent'' at each stage of secondary group sequential design\cr
   \code{Imax}\tab maximum information number\cr
   \code{delta}\tab effect size used for planning the secondary trial\cr
   \code{cp}\tab conditional power\cr
}
A value of \code{SF}=3 is the power family. Here, the spending function is \eqn{t^{\phi}},
where phi must be greater than 0. A value of \code{SF}=4 is the Hwang-Shih-DeCani family,
with the spending function \eqn{(1-e^{-\phi t})/(1-e^{-\phi})}, where phi cannot be 0.
}
\examples{
##The following performs an adaptation of the sample size and
##number of interim analyses after the first stage of the primary trial.

pT=plan.GST(K=3,SF=4,phi=-4,alpha=0.05,delta=6,pow=0.9,compute.alab=TRUE,compute.als=TRUE)

iD=list(T=1, z=1.090728)

swImax=0.0625

I2min=3*swImax
I2max=3*swImax

sT=adapt(pT=pT,iD=iD,SF=1,phi=0,cp=0.8,theta=5,I2min,I2max,swImax)
}
\author{
Niklas Hack \email{niklas.hack@meduniwien.ac.at} and Werner Brannath \email{werner.brannath@meduniwien.ac.at}
}
\references{
Brannath, W, Mehta, CR, Posch, M (2008) ''Exact confidence bounds following adaptive group sequential tests'', \emph{Biometrics} accepted.
}
\seealso{
\code{\link{GSTobj}}, \code{\link{print.GSTobj}}, \code{\link{plot.GSTobj}}, \code{\link{plan.GST}}
}
\keyword{methods}

