% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reg_test.R
\name{reg_test}
\alias{reg_test}
\title{Test for detecting violation of Gauss-Markov assumptions.}
\usage{
reg_test(y)
}
\arguments{
\item{y}{A numeric vector or an object of class \code{lm}.}
}
\value{
\code{reg_test} returns an object of class \code{"reg_test"}.
An object of class \code{"reg_test"} is a list containing the
following components:

\item{bp}{Breusch-Pagan statistic}
\item{bg}{Breusch-Godfrey statistic}
\item{dw}{Durbin-Watson statistic}
\item{gq}{Godfrey-Quandt statistic}
}
\description{
Test for detecting violation of Gauss-Markov assumptions.
}
\examples{
model <- lm(real_gdp~ imp + exp + poil + eurkzt + usdkzt, macroKZ)
reg_test(model)
}
