% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AFMPSDAnalyser.R
\name{shiftFFT2D}
\alias{shiftFFT2D}
\title{Shift the quadrants of the FFT 2D}
\usage{
shiftFFT2D(fft2data)
}
\arguments{
\item{fft2data}{the FFT 2D of the AFM image}
}
\value{
The shifted matrix
}
\description{
\code{shiftFFT2D} returns the FFT 2D matrix shifted to put zero frequencies in the middle.
}
\examples{
library(AFM)
library(fftwtools)

data(AFMImageOfNormallyDistributedHeights)
AFMImage<-AFMImageOfNormallyDistributedHeights
nMheightsData= matrix(AFMImage@data$h, nrow=AFMImage@samplesperline)
shiftedFFT2D<-shiftFFT2D(fftwtools::fftw2d(nMheightsData))
}
\author{
M.Beauvais
}
