\name{ADDT-package}
\alias{ADDT-package}
\alias{ADDT}
\docType{package}
\title{
Accelerated Destructive Degradation Testing
}
\description{
Accelerated destructive degradation tests (ADDT) are often used to collect necessary data for assessing the long-term properties of polymeric materials. Based on the collected data, a thermal index (TI) is estimated. The TI can be useful for material rating and comparison. This package performs the least squares (LS) and maximum likelihood (ML) procedures for estimating TI for polymeric materials. The LS approach is a two-step approach that is currently used in industrial standards, while the ML procedure is widely used in the statistical literature. The ML approach allows one to do statistical inference such as quantifying uncertainties in estimation, hypothesis testing, and predictions. Two publicly available datasets are provided to allow users to experiment and practice with the functions.
}
\details{
\tabular{ll}{
Package: \tab ADDT\cr
Type: \tab Package\cr
Version: \tab 1.0\cr
Date: \tab 2014-09-23\cr
License: \tab GPL-2\cr
}
}
\author{
Yili Hong, Yimeng Xie, and Caleb King

Maintainer: Yili Hong <yilihong@vt.edu>
}
\references{
Hong, Y., King, C. B., Xie, Y., Van Mullekom, J. H., Dehart, S. P. and DeFeo, P. A. (2014). A Comparison of Least Squares and Maximum Likelihood Approaches to Estimating Thermal Indices for Polymeric Materials. \emph{Technical Report}.

Escobar, L. A., W. Q. Meeker, D. L. Kugler, and L. L. Kramer (2003). Accelerated destructive degradation tests: Data, models, and analysis. \emph{Singapore: World Scientific Publishing Company}.

Li, M. and N. Doganaksoy (2014). Batch variability in accelerated-degradation testing. \emph{Journal of Quality Technology 46(2)}, 171--180.

}
\keyword{ package }
