% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.ACDCsets.R
\name{print.ACDCsets}
\alias{print.ACDCsets}
\title{print.ACDCsets}
\usage{
\method{print}{ACDCsets}(x, ...)
}
\arguments{
\item{x}{a list of (congruent) ACDC sets}

\item{...}{additional parameters}
}
\value{
nothing
}
\description{
print.ACDCsets
}
\examples{
data(primates_ebd_log)

posterior <- read.RevBayes(primates_ebd_log, max_t = 65, n_samples = 20)

samples <- sample.congruence.class.posterior(posterior, 
                                             num.samples = 20,
                                             rate.type = "extinction",
                                             rate0.median = 0.1,
                                             model = "MRF",
                                             max.rate = 1.0)
                                             
print(samples)
}
