% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readABHgenotypes.R
\name{readABHgenotypes}
\alias{readABHgenotypes}
\title{Read in the output of the genosToABH plugin.}
\usage{
readABHgenotypes(pathToABH, nameA = "A", nameB = "B", readPos = TRUE)
}
\arguments{
\item{pathToABH}{The path and filename of the input file.}

\item{nameA}{Name of the parent represented by "A" in the input file.}

\item{nameB}{Name of the parent represented by "B" in the input file.}

\item{readPos}{Should the function attempt read the physical position of
markers from the input ?}
}
\value{
A genotype list object which holds the information from the input file.
 This list is the fundamental datastructure used by the other functions in this
 package. See the vignette for what each item in the list is.
}
\description{
Read in the output of the genosToABH plugin.
}
\details{
The input files should be a .csv file holding genotypes as specified by
 the qtl package and its "csvs" format.
 All characters in the genotype matrix which are not either A,B or H
 will be set to N.
 If readPos = TRUE (default) marker names must conform to S1_123456 meaning 123456 bp
 on chromosome 1. If FALSE, pos is set to NULL and needs to be manually constructed
 as shown in the examples. Note that this might throw off some plotting function.
}
\examples{
\dontrun{genotypes <- readABHgenotypes("./genotypes.csv", "NB", "OL")}

 \dontrun{otherGenotypes <- readABHgenotypes("./otherGenotypes.csv", readPos = FALSE)}
 #arbitrary position to keep marker order intact
 \dontrun{therGenotypes$pos <- 1:length(otherGenotypes$marker_names)}
}

